/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlDrawable
extends ControlElement {
    public static final int DRAWABLE_NAME = 0;
    public static final int PARENT = 1;
    protected ControlParentOfDrawables myParent;
    private Drawable myDrawable = this.createDrawable();
    private String menuNameEntry = null;
    private static List<String> infoList = null;

    public ControlDrawable() {
        this.myObject = this.myDrawable;
    }

    protected abstract Drawable createDrawable();

    protected void setName(String string) {
    }

    public final Drawable getDrawable() {
        return this.myDrawable;
    }

    public final void setDrawable(Drawable drawable) {
        this.myDrawable = drawable;
    }

    public void setParent(ControlParentOfDrawables controlParentOfDrawables) {
        if (this.myParent != null) {
            this.myParent.removeDrawable(this.myDrawable);
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
        }
        if (controlParentOfDrawables != null) {
            int n = -1;
            String string = this.getProperty("_ejs_indexInParent_");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            this.setProperty("_ejs_indexInParent_", null);
            if (n >= 0) {
                controlParentOfDrawables.addDrawableAtIndex(n, this.myDrawable);
            } else {
                controlParentOfDrawables.addDrawable(this.myDrawable);
            }
            if (this.isUnderEjs) {
                controlParentOfDrawables.getDrawingPanel().render();
            }
            if (this instanceof NeedsPreUpdate) {
                controlParentOfDrawables.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent = controlParentOfDrawables;
        }
    }

    public final ControlParentOfDrawables getParent() {
        return this.myParent;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.myParent instanceof ControlDrawablesParent) {
            ((ControlDrawablesParent)this.myParent).getDrawingPanel().render();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("menuName");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        return null;
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setName(value.getString());
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlParentOfDrawables) {
                    this.setParent((ControlParentOfDrawables)((Object)controlElement));
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlParentOfDrawables");
                break;
            }
            case 2: {
                this.menuNameEntry = value.getString();
                this.setName(this.menuNameEntry);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setName("");
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.menuNameEntry = null;
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "null";
            }
            case 2: {
                return this.getProperty("name");
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    @Override
    public Value getValue(int n) {
        return null;
    }
}

