/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlWindow
extends ControlContainer
implements NeedsUpdate {
    public static final int WINDOW_ADDED = 5;
    public static final int WINDOW_LOCATION = 1;
    public static final int WINDOW_NAME = 5;
    public static final int WINDOW_VISIBLE = 9;
    public static final int WINDOW_SIZE = 10;
    private static final Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static boolean keepHidden = false;
    private Window myWindow;
    private LayoutManager myLayout = null;
    private Point myLocation = null;
    private Dimension mySize = null;
    protected boolean waitForReset = false;
    protected boolean startingup = true;
    protected boolean shouldShow = true;
    protected JMenuBar menubar = null;
    private Border originalBorder;
    private boolean notFirstTimeMoved = false;
    private boolean notFirstTimeSized = false;
    private ObjectValue locationValue;
    private ObjectValue sizeValue;
    protected BooleanValue internalValue;
    private static List<String> infoList = null;

    public static void setKeepHidden(boolean bl) {
        keepHidden = bl;
    }

    public ControlWindow() {
        this.setListeners();
        this.originalBorder = this.getRootPane().getBorder();
        this.adjustBorder();
    }

    protected abstract int getVisibleIndex();

    protected abstract int getLocationIndex();

    protected abstract int getSizeIndex();

    protected abstract JRootPane getRootPane();

    public void adjustBorder() {
        int n = EjsControl.getBorderWidthAroundWindows();
        JRootPane jRootPane = this.getRootPane();
        if (n == 0) {
            jRootPane.setBorder(this.originalBorder);
        } else {
            if (n < 0) {
                n = -1;
            }
            Icon icon = EjsControl.getBorderIconAroundWindows();
            Color color = EjsControl.getBorderColorAroundWindows();
            jRootPane.setOpaque(true);
            MatteBorder matteBorder = icon == null ? BorderFactory.createMatteBorder(n, n, n, n, color) : BorderFactory.createMatteBorder(n, n, n, n, icon);
            String string = EjsControl.getBorderTitleAroundWindows();
            if (string == null) {
                jRootPane.setBorder(matteBorder);
            } else {
                TitledBorder titledBorder = BorderFactory.createTitledBorder(matteBorder, " " + string + " ");
                titledBorder.setTitleJustification(2);
                titledBorder.setTitlePosition(2);
                titledBorder.setTitleColor(EjsControl.getBorderTitleColorAroundWindows());
                jRootPane.setBorder(titledBorder);
            }
        }
        this.myWindow.validate();
        this.myWindow.pack();
    }

    @Override
    public boolean acceptsChild(ControlElement controlElement) {
        return controlElement instanceof ControlSwingElement;
    }

    public void updateLocation() {
        Point point = this.getComponent().getLocation();
        this.setLocation(point.x, point.y);
    }

    protected void setLocation(int n, int n2) {
        if (this.myGroup != null) {
            Point point = this.myGroup.getDisplacement();
            n2 += point.y;
            Rectangle rectangle = EjsControl.getDefaultScreenBounds();
            if ((n += point.x) < 0) {
                n = 0;
            } else if (n > rectangle.width - this.getComponent().getWidth()) {
                n = rectangle.width - this.getComponent().getWidth();
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > rectangle.height - this.getComponent().getHeight()) {
                n2 = rectangle.height - this.getComponent().getHeight();
            }
            n += rectangle.x;
            n2 += rectangle.y;
        } else {
            if (n < 0) {
                n = 0;
            } else if (n > ControlWindow.ScreenSize.width - this.getComponent().getWidth()) {
                n = ControlWindow.ScreenSize.width - this.getComponent().getWidth();
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > ControlWindow.ScreenSize.height - this.getComponent().getHeight()) {
                n2 = ControlWindow.ScreenSize.height - this.getComponent().getHeight();
            }
        }
        this.getComponent().setLocation(n, n2);
    }

    protected Point getLocation() {
        if (this.myGroup != null) {
            Point point = this.myGroup.getDisplacement();
            Point point2 = this.getComponent().getLocation();
            Rectangle rectangle = EjsControl.getDefaultScreenBounds();
            return new Point(point2.x - point.x - rectangle.x, point2.y - point.y - rectangle.y);
        }
        return this.getComponent().getLocation();
    }

    protected void setListeners() {
        this.myWindow = (Window)this.getComponent();
        this.locationValue = new ObjectValue(this.getLocation());
        this.sizeValue = new ObjectValue(this.getContainer().getSize());
        this.myWindow.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                ObjectValue objectValue = ControlWindow.this.locationValue;
                Point point = ControlWindow.this.getLocation();
                ControlWindow.this.myLocation = point;
                objectValue.value = point;
                if (ControlWindow.this.isUnderEjs && ControlWindow.this.notFirstTimeMoved) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getLocationIndex(), ControlWindow.this.locationValue, false);
                }
                ControlWindow.this.notFirstTimeMoved = true;
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (ControlWindow.this.startingup || !ControlWindow.this.notFirstTimeSized) {
                    ControlWindow.this.notFirstTimeSized = true;
                    return;
                }
                ObjectValue objectValue = ControlWindow.this.sizeValue;
                Dimension dimension = ControlWindow.this.getContainer().getSize();
                ControlWindow.this.mySize = dimension;
                objectValue.value = dimension;
                if (ControlWindow.this.isUnderEjs) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getSizeIndex(), ControlWindow.this.sizeValue, false);
                }
                ControlWindow.this.invokeActions(10);
            }
        });
        this.myWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ControlWindow.this.whenClosing();
            }
        });
    }

    protected void whenClosing() {
        this.internalValue.value = false;
        this.variableChanged(this.getVisibleIndex(), this.internalValue);
        this.invokeActions(21);
    }

    public void dispose() {
        ((Window)this.getComponent()).setVisible(false);
        ((Window)this.getComponent()).dispose();
    }

    public void show() {
        Window window;
        if (keepHidden) {
            return;
        }
        if (this.startingup) {
            this.shouldShow = true;
            if (this.waitForReset) {
                return;
            }
        }
        if (!(window = (Window)this.getComponent()).isShowing()) {
            window.setVisible(true);
        }
    }

    public void hide() {
        Window window;
        if (this.startingup) {
            this.shouldShow = false;
            if (this.waitForReset) {
                return;
            }
        }
        if ((window = (Window)this.getComponent()).isShowing()) {
            window.setVisible(false);
        }
    }

    @Override
    public void destroy() {
        this.dispose();
        super.destroy();
    }

    public void setWaitForReset(boolean bl) {
        this.waitForReset = bl;
        if (this.waitForReset) {
            ((Window)this.getComponent()).setVisible(false);
        }
    }

    @Override
    public void reset() {
        this.startingup = false;
        if (this.shouldShow) {
            this.show();
        } else {
            this.hide();
        }
        Window window = (Window)this.getComponent();
        window.repaint();
        super.reset();
    }

    @Override
    public void update() {
        this.startingup = false;
    }

    @Override
    public void adjustSize() {
        this.getContainer().setPreferredSize(this.mySize);
        this.myWindow.validate();
        this.myWindow.pack();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("layout");
            infoList.add("location");
            infoList.add("waitForReset");
            infoList.add("onClosing");
            infoList.add("resizeAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("location")) {
            return "Point|Object|String NO_RESET";
        }
        if (string.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (string.equals("waitForReset")) {
            return "boolean";
        }
        if (string.equals("onClosing")) {
            return "Action CONSTANT";
        }
        if (string.equals("resizeAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE NO_RESET";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (!(value.getObject() instanceof LayoutManager)) break;
                LayoutManager layoutManager = (LayoutManager)value.getObject();
                if (layoutManager != this.myLayout) {
                    this.myLayout = layoutManager;
                    this.getContainer().setLayout(this.myLayout);
                    this.adjustChildren();
                }
                this.myWindow.validate();
                break;
            }
            case 1: {
                Point point = null;
                if (value.getObject() instanceof Point) {
                    point = (Point)value.getObject();
                } else {
                    Value value2 = ConstantParser.pointConstant(value.getString());
                    if (value2 == null) {
                        return;
                    }
                    point = (Point)value2.getObject();
                }
                this.locationValue.value = point;
                if (point.equals(this.myLocation)) {
                    return;
                }
                this.myLocation = point;
                this.setLocation(point.x, point.y);
                break;
            }
            case 2: {
                this.setWaitForReset(value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                this.addAction(21, value.getString());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                this.addAction(10, value.getString());
                break;
            }
            case 9: {
                this.internalValue.value = value.getBoolean();
                if (this.internalValue.value) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 10: {
                Object object;
                Dimension dimension = null;
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                if (value instanceof StringValue) {
                    if ("pack".equals(value.getString())) {
                        this.myWindow.pack();
                        this.mySize = dimension = this.getContainer().getSize();
                        this.sizeValue.value = dimension;
                    } else {
                        object = ConstantParser.dimensionConstant(value.getString());
                        if (object == null) {
                            return;
                        }
                        dimension = (Dimension)((Value)object).getObject();
                        if (dimension.width > dimension2.width) {
                            dimension.width = dimension2.width;
                        }
                        if (dimension.height > dimension2.height) {
                            dimension.height = dimension2.height;
                        }
                        this.sizeValue.value = dimension;
                        if (dimension.equals(this.mySize)) {
                            return;
                        }
                        this.mySize = dimension;
                        this.getContainer().setPreferredSize(this.mySize);
                        this.myWindow.validate();
                        this.myWindow.pack();
                    }
                } else if (value.getObject() instanceof Dimension) {
                    dimension = (Dimension)value.getObject();
                    if (dimension.width > dimension2.width) {
                        dimension.width = dimension2.width;
                    }
                    if (dimension.height > dimension2.height) {
                        dimension.height = dimension2.height;
                    }
                    this.sizeValue.value = dimension;
                    if (dimension.equals(this.mySize)) {
                        return;
                    }
                    this.mySize = dimension;
                    this.getContainer().setPreferredSize(this.mySize);
                    this.myWindow.validate();
                    this.myWindow.pack();
                } else {
                    return;
                }
                object = this.getProperty("location");
                if (object == null || !((String)object).trim().toLowerCase().equals("center")) break;
                this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.myWindow.validate();
                break;
            }
            case 1: {
                this.myLocation = new Point(0, 0);
                this.setLocation(0, 0);
                this.locationValue.value = this.myLocation;
                break;
            }
            case 2: {
                this.setWaitForReset(false);
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                break;
            }
            case 9: {
                this.internalValue.value = true;
                this.show();
                break;
            }
            case 10: {
                ((Window)this.getComponent()).pack();
                Dimension dimension = this.getContainer().getSize();
                this.sizeValue.value = dimension;
                String string = this.getProperty("location");
                if (string == null || !string.trim().toLowerCase().equals("center")) break;
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "BORDER";
            }
            case 1: {
                return "0,0";
            }
            case 2: {
                return "false";
            }
            case 3: 
            case 4: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(n - 5);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
            case 1: {
                return this.locationValue;
            }
            case 9: {
                return this.internalValue;
            }
            case 10: {
                return this.sizeValue;
            }
        }
        return super.getValue(n - 5);
    }
}

